package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;

import gov.va.med.mhv.calendar.dto.CalendarEventDTO;
import gov.va.med.mhv.calendar.model.CalendarEvent;

public class CalendarEventConverter implements Converter<CalendarEvent, CalendarEventDTO> {

	@Override
	public CalendarEventDTO convert(CalendarEvent source) {
		CalendarEventDTO target = new CalendarEventDTO();
		
		target.setEventId(source.getEventId());
		target.setTimeZone(source.getTimeZone());
		target.setStartDate(source.getStartDate());
		target.setReminderDate(source.getReminderDate());
		target.setLink(source.getLink());
		target.setRecurUntilDate(source.getRecurUntilDate());
		target.setReminderInterval(source.getReminderInterval());
		target.setEndDate(source.getEndDate());
		target.setAllDay(source.getAllDay());
		target.setVhaEvent(source.getVhaEvent());
		target.setDescription(source.getDescription());
		target.setRecurrenceInterval(source.getRecurrenceInterval());
		target.setEndDate(source.getEndDate());
		target.setSubject(source.getSubject());
		target.setLocation(source.getLocation());
		target.setApiEventKey(source.getApiEventKey());
		target.setRepeating(source.getRepeating());
		target.setUserProfileId(source.getUserProfileId());
		
		
		if (null != source.getCalendarCategory()) {
			target.setCalendarCategory(new CalendarCategoryConverter().convert(source.getCalendarCategory()));
		}
		
		if (null != source.getVisn()) {
			target.setVisn(new VisnConverter().convert(source.getVisn()));
		}
		
		return target;
	}
	
	public CalendarEvent convert(CalendarEventDTO source) {
		CalendarEvent target = new CalendarEvent();
		
		target.setEventId(source.getEventId());
		target.setTimeZone(source.getTimeZone());
		target.setStartDate(source.getStartDate());
		target.setReminderDate(source.getReminderDate());
		target.setLink(source.getLink());
		target.setRecurUntilDate(source.getRecurUntilDate());
		target.setReminderInterval(source.getReminderInterval());
		target.setEndDate(source.getEndDate());
		target.setAllDay(source.getAllDay());
		target.setVhaEvent(source.getVhaEvent());
		target.setDescription(source.getDescription());
		target.setRecurrenceInterval(source.getRecurrenceInterval());
		target.setEndDate(source.getEndDate());
		target.setSubject(source.getSubject());
		target.setLocation(source.getLocation());
		target.setApiEventKey(source.getApiEventKey());
		target.setRepeating(source.getRepeating());
		target.setUserProfileId(source.getUserProfileId());
		target.setOplock(0);
		
		if (null != source.getCalendarCategory()) {
			target.setCalendarCategory(new CalendarCategoryConverter().convert(source.getCalendarCategory()));
		}
		
		if (null != source.getVisn()) {
			target.setVisn(new VisnConverter().convert(source.getVisn()));
		}
		
		return target;
	}
	
	
	
	public List<CalendarEventDTO> convert(List<CalendarEvent> source) {
		List<CalendarEventDTO> calendarEventDto = null;
		
		if (null != source) {
			calendarEventDto = new ArrayList<CalendarEventDTO>();
			
			for (CalendarEvent calendarEvent : source) {
				calendarEventDto.add(this.convert(calendarEvent));
			}
		}
		
		return calendarEventDto;
	}

}
